import asyncio
from asyncua import ua, Server
import random

async def main():
    # create a server
    server = Server()
    await server.init()
    # set endpoint information
    url = "opc.tcp://localhost:4840/myopc/free"
    server.set_endpoint(url)
    # create a new address space
    uri = "http://klopc.com"
    idx = await server.register_namespace(uri)
    obj = await server.nodes.objects.add_object(idx, "MyObject")
    var = await obj.add_variable(idx, "MyVariable", 0)
    await var.set_writable()

    # start the server
    await server.start()

    try:
        # keep the server running until interrupted
        while True:
            await var.write_value(random.randint(1, 100))
            await asyncio.sleep(1)
    finally:
        # stop the server
        await server.stop()

if __name__ == "__main__":
    asyncio.run(main())
